<!DOCTYPE html>
<html lang="zxx">
    <head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Links Of CSS File -->
		<link rel="stylesheet" href="assets/css/sidebar-menu.css">
		<link rel="stylesheet" href="assets/css/simplebar.css">
		<link rel="stylesheet" href="assets/css/apexcharts.css">
		<link rel="stylesheet" href="assets/css/prism.css">
		<link rel="stylesheet" href="assets/css/rangeslider.css">
        <link rel="stylesheet" href="assets/css/quill.snow.css">
        <link rel="stylesheet" href="assets/css/google-icon.css">
        <link rel="stylesheet" href="assets/css/remixicon.css">
        <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
        <link rel="stylesheet" href="assets/css/fullcalendar.main.css">
        <link rel="stylesheet" href="assets/css/jsvectormap.min.css">
        <link rel="stylesheet" href="assets/css/lightpick.css">
		<link rel="stylesheet" href="assets/css/style.css">
		
		<!-- Favicon -->
		<link rel="icon" type="image/png" href="assets/images/favicon.png">
		<!-- Title -->
		<title>ArntsAdm - Sistema Web de Administração</title>
    </head>
    <body data-bs-spy="scroll" data-bs-target="#navbar-example2" data-bs-root-margin="0px 0px -40%" data-bs-smooth-scroll="true" class="scrollspy-example" tabindex="0">
        <!-- Start Preloader Area -->
        <div class="preloader" id="preloader">
            <div class="preloader">
                <div class="waviy position-relative">
                    <span class="d-inline-block">A</span>
                    <span class="d-inline-block">R</span>
                    <span class="d-inline-block">A</span>
                    <span class="d-inline-block">N</span>
                    <span class="d-inline-block">T</span>
                    <span class="d-inline-block">E</span>
                    <span class="d-inline-block">S</span>
                    <span class="d-inline-block">T</span>
                    <span class="d-inline-block">E</span>
                    <span class="d-inline-block">C</span>
                </div>
            </div>
        </div>
        <!-- End Preloader Area -->

        <!-- Start Navbar Area -->
        <nav class="navbar navbar-expand-lg bg-transparent bg-opacity-25 fixed-top" id="navbar">
            <div class="container">
                <a class="navbar-brand me-xl-5 me-3" href="landing-page.php">
                    <img src="assets/images/landing/logo.svg" alt="logo">
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                        <li class="nav-item">
                            <a class="nav-link fs-16 fw-medium text-body hover px-0 px-md-2 mx-1 mx-xl-0 px-xl-4" href="landing-page.php">Home</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link fs-16 fw-medium text-body hover px-0 px-md-2 mx-1 mx-xl-0 px-xl-4" href="features.php">Features</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link fs-16 fw-medium text-body hover px-0 px-md-2 mx-1 mx-xl-0 px-xl-4" href="our-team.php">Our Team</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link fs-16 fw-medium text-body hover px-0 px-md-2 mx-1 mx-xl-0 px-xl-4" href="faqs.php">FAQ’s</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link fs-16 fw-medium text-body hover px-0 px-md-2 mx-1 mx-xl-0 px-xl-4 active" href="contact.php">Contact</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link fs-16 fw-medium text-body hover px-0 px-md-2 mx-1 mx-xl-0 px-xl-4" href="index.php">Admin</a>
                        </li>
                    </ul>
                    <div class="othres">
                        <a href="login.php" class="btn btn-outline-primary-div py-2 px-4 fw-medium fs-16 rounded-3">
                            <i class="ri-login-box-line fs-18 position-relative top-2"></i>
                            <span class="ms-1">Login</span>
                        </a>
                        <a href="register.php" class="btn btn-primary-div py-2 px-4 fw-medium fs-16 text-white ms-3 rounded-3">
                            <i class="ri-user-line fs-18"></i>
                            <span class="ms-1">Register</span>
                        </a>
                    </div>
                </div>
            </div>
        </nav>
        <!-- End Navbar Area -->

        <!-- Start Banner Area -->
        <div class="page-banner-area" id="home">
            <div class="container position-relative z-1">
                <div class="banner-content text-center mb-0">
                    <h1 class="fs-60 mb-0">Contact Us</h1>
                </div>

                <img src="assets/images/landing/shape-5.png" class="shape-5" alt="shape">
                <img src="assets/images/landing/shape-6.png" class="shape-6" alt="shape">
            </div>
        </div>
        <!-- End Banner Area -->

        <!-- Start Contact Us Area -->
        <div class="contact-us-area pt-150 position-relative z-2" id="contact">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="contact-us-img mb-4 mb-lg-0">
                            <img src="assets/images/landing/contact-us.jpg" alt="contact-us">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="contact-us-form ms-xl-4">
                            <span class="top-title">
                                <span>Contact Us</span>
                            </span>
                            <h2>Introducing Our Exceptional Team. Meet the Minds Driving Our Success</h2>
                            <form>
                                <div class="form-group mb-4">
                                    <label class="label text-secondary">Full Name</label>
                                    <input type="text" class="form-control bg-transparent h-55" placeholder="Your full name">
                                </div>
                                <div class="form-group mb-4">
                                    <label class="label text-secondary">Email Address</label>
                                    <input type="email" class="form-control bg-transparent h-55" placeholder="Your email address">
                                </div>
                                <div class="form-group mb-4">
                                    <label class="label text-secondary">Phone Number</label>
                                    <input type="text" class="form-control bg-transparent h-55" placeholder="Your phone number">
                                </div>
                                <div class="form-group mb-4">
                                    <label class="label text-secondary">Subject</label>
                                    <select class="form-select form-control bg-transparent h-55" aria-label="Default select example">
                                        <option selected>Select your subject</option>
                                        <option value="1">Help Dask</option>
                                        <option value="2">LMS</option>
                                        <option value="3">CRM</option>
                                    </select>
                                </div>
                                <div class="form-group mb-4">
                                    <label class="label text-secondary">Phone Number</label>
                                    <textarea rows="5" class="form-control bg-transparent" placeholder="Write your message..."></textarea>
                                </div>
                                <div class="form-group mb-0">
                                    <button type="submit" class="btn btn-primary py-2 px-4 w-100">
                                        <i class="ri-refresh-line fs-18 text-white position-relative top-1 me-1"></i>
                                        <span>Send</span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Contact Us Area -->

        <!-- Start Unlock Area -->
        <div class="unlock-area ptb-150 position-relative z-1" id="admin">
            <div class="container">
                <div class="border-bottom pb-150">
                    <div class="row">
                        <div class="unlock-content">
                            <h2>Unlock a world of possibilities with Trezo Dashboard.</h2>
                            <p>Experience the difference with Trezo Dashboard. Sign up for a free trial today and see how our intuitive platform can revolutionize your data analysis process.</p>
                            <a href="contact.php" class="btn btn-primary-div py-2 px-4 fs-16 fw-medium rounded-3 text-white">
                                <i class="ri-user-line fs-18"></i>
                                <span class="ms-1">Get started - It is free</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <img src="assets/images/landing/shape-1.png" class="shape shape-5" alt="shape">
            <img src="assets/images/landing/shape-2.png" class="shape shape-6" alt="shape">
        </div>
        <!-- End Unlock Area -->

        <!-- Start Forter Area -->
        <div class="footers-area pb-125 position-relative z-2">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-sm-6">
                        <div class="footer-single-item mb-4">
                            <a href="#" class="footer-logo d-inline-block mb-4">
                                <img src="assets/images/landing/logo.svg" alt="logo">
                            </a>
                            <p class="mb-4 pb-lg-2">With customizable dashboards tailored to your needs, collaborate effortlessly with your team and stay ahead with real-time updates.</p>

                            <ul class="ps-0 mb-0 list-unstyled d-flex flex-wrap gap-3">
                                <li>
                                    <a href="https://www.facebook.com/" target="_blank" class="text-decoration-none fs-20 text-primary">
                                        <i class="ri-facebook-fill"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="https://www.twitter.com/" target="_blank" class="text-decoration-none fs-20 text-primary">
                                        <i class="ri-twitter-x-line"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="https://www.linkedin.com/" target="_blank" class="text-decoration-none fs-20 text-primary">
                                        <i class="ri-linkedin-fill"></i>
                                    </a>
                                </li>
                                <li>
                                    <a href="https://www.dribbble.com/" target="_blank" class="text-decoration-none fs-20 text-primary">
                                        <i class="ri-dribbble-line"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="footer-single-item mb-4 ms-lg-5 ps-lg-5">
                            <h3 class="mb-md-4 mb-3 fw-semibold">Our Products</h3>
                            <ul class="ps-0 mb-0 list-unstyled">
                                <li class="mb-2 pb-1">
                                    <a href="#" class="text-decoration-none">Trezo Dashboard</a>
                                </li>
                                <li class="mb-2 pb-1">
                                    <a href="#" class="text-decoration-none">Tagus Admin</a>
                                </li>
                                <li class="mb-2 pb-1">
                                    <a href="#" class="text-decoration-none">eCademy LMS</a>
                                </li>
                                <li class="mb-0">
                                    <a href="#" class="text-decoration-none">Admash Template</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="footer-single-item mb-4 ms-lg-5 ps-lg-4">
                            <h3 class="mb-md-4 mb-3 fw-semibold">Quick Links</h3>
                            <ul class="ps-0 mb-0 list-unstyled">
                                <li class="mb-2 pb-1">
                                    <a href="landing-page.php" class="text-decoration-none">Home</a>
                                </li>
                                <li class="mb-2 pb-1">
                                    <a href="features.php" class="text-decoration-none">Features</a>
                                </li>
                                <li class="mb-2 pb-1">
                                    <a href="faqs.php" class="text-decoration-none">Testimonials</a>
                                </li>
                                <li class="mb-0">
                                    <a href="our-team.php" class="text-decoration-none">Our Team</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="footer-single-item mb-4">
                            <h3 class="mb-md-4 mb-3 fw-semibold">Privacy Policy</h3>
                            <ul class="ps-0 mb-0 list-unstyled">
                                <li class="mb-2 pb-1">
                                    <a href="#" class="text-decoration-none">Terms & Conditions</a>
                                </li>
                                <li class="mb-2 pb-1">
                                    <a href="#" class="text-decoration-none">Cookie Policy</a>
                                </li>
                                <li class="mb-2 pb-1">
                                    <a href="#" class="text-decoration-none">Notice at Collection</a>
                                </li>
                                <li class="mb-0">
                                    <a href="#" class="text-decoration-none">Privacy Policy</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Forter Area -->

        <!-- Start CopyRight Area -->
        <div class="copyright-area bg-white text-center py-4">
            <div class="container">
                <p class="fs-14">© <span class="text-primary-div">ArntsAdm</span> é desemvolvido por <a href="https://arantestecnologia.com.br/" target="_blank" class="text-decoration-none text-primary">ARANTES TECNOLOGIA</a></p>
            </div>
        </div>
        <!-- End CopyRight Area -->

        <!-- Start Back To Up Area -->
		<button type="button" id="backtotop"> 
			<i class="ri-arrow-up-s-line"></i>
		</button>
		<!-- End Back To Up Area -->

        <button class="switch-toggle settings-btn dark-btn p-0 bg-transparent position-absolute top-0 d-none" id="switch-toggle">
            <span class="dark"><i class="material-symbols-outlined">light_mode</i></span> 
            <span class="light"><i class="material-symbols-outlined">dark_mode</i></span>
        </button>
     
        <!-- Link Of JS File -->
        <script src="assets/js/bootstrap.bundle.min.js"></script>
        <script src="assets/js/sidebar-menu.js"></script>
        <script src="assets/js/dragdrop.js"></script>
        <script src="assets/js/rangeslider.min.js"></script>
        <script src="assets/js/quill.min.js"></script>
        <script src="assets/js/data-table.js"></script>
        <script src="assets/js/prism.js"></script>
        <script src="assets/js/clipboard.min.js"></script>
        <script src="assets/js/feather.min.js"></script>
        <script src="assets/js/simplebar.min.js"></script>
        <script src="assets/js/apexcharts.min.js"></script>
        <script src="assets/js/echarts.min.js"></script>
        <script src="assets/js/swiper-bundle.min.js"></script>
        <script src="assets/js/fullcalendar.main.js"></script>
        <script src="assets/js/jsvectormap.min.js"></script>
        <script src="assets/js/world-merc.js"></script>
        <script src="assets/js/moment.min.js"></script>
        <script src="assets/js/lightpick.js"></script>
        <script src="assets/js/custom/apexcharts.js"></script>
        <script src="assets/js/custom/echarts.js"></script>
        <script src="assets/js/custom/custom.js"></script>
    </body>
</html>