<?php
require "../config/db.php";
@ini_set('display_errors', '1');
error_reporting(E_ALL);
session_start();
date_default_timezone_set('America/Sao_Paulo');

// Pega o número de cadastro da URL
if (isset($_GET['ncadastro'])) {
    $ncadastro = $conn->real_escape_string($_GET['ncadastro']);
} else {
    die("<h3 style='text-align:center; color:red;'>Número de cadastro não informado.</h3>");
}

// Busca os dados do cadastro
$sql = "SELECT * FROM cadastro WHERE ncadastro = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $ncadastro);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows === 0) {
    die("<h3 style='text-align:center; color:red;'>Cadastro não encontrado.</h3>");
}

$dados = $res->fetch_assoc();
$nome_cadastro = $dados['nome_completo'];
$cpf_cadastro = $dados['cpf_cnpj'];
$email_principal = $dados['email_principal'];
$tel_celular = $dados['telefone_celular'];
$cep_residencial = $dados['cep'] ?? '';
$logradouro_residencial = $dados['endereco'] ?? '';
$numero_residencial = $dados['numero'] ?? '';
$bairro_residencial = $dados['bairro'] ?? '';
$cidade_residencial = $dados['cidade'] ?? '';
$estado_residencial = $dados['estado'] ?? '';
$data_cadastro = date("Y-m-d H:i:s");

// ===== GERA TOKEN SEGURO (idempotência) =====
$chaveSegura = 'FFACMHE_2025_PIX_KEY';
$token = hash_hmac('sha256', uniqid($ncadastro, true), $chaveSegura);

// ===== CRIA COBRANÇA PIX (MercadoPago) =====
$dadosPix = [
    "transaction_amount" => 00.10,
    "description" => "CARTEIRA CERTIFICADA COM QR CODE",
    "external_reference" => $ncadastro,
    "payment_method_id" => "pix",
    "notification_url" => "https://teste.arantestecnologia.com.br/carteira/pagamento/notification.php",
    "payer" => [
        "email" => $email_principal,
        "first_name" => $nome_cadastro,
        "last_name" => "CREDENCIADO",
        "identification" => [
            "type" => "CPF",
            "number" => $cpf_cadastro
        ],
        "address" => [
            "zip_code" => $cep_residencial,
            "street_name" => $logradouro_residencial,
            "street_number" => $numero_residencial,
            "neighborhood" => $bairro_residencial,
            "city" => $cidade_residencial,
            "federal_unit" => $estado_residencial
        ]
    ]
];

// ===== CHAMADA À API Mercado Pago =====
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'https://api.mercadopago.com/v1/payments',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => json_encode($dadosPix),
    CURLOPT_HTTPHEADER => [
        'accept: application/json',
        'content-type: application/json',
        'X-Idempotency-Key: ' . $token,
        'Authorization: Bearer APP_USR-2436048829893619-100910-55c3c8158a25c7da48cc958cf677ae56-35703420'
    ],
]);

$response = curl_exec($curl);
$resultado = json_decode($response);
curl_close($curl);

// ===== VALIDA RESPOSTA =====
if (
    !isset($resultado->id) ||
    !isset($resultado->status) ||
    !isset($resultado->point_of_interaction->transaction_data->qr_code)
) {
    error_log("Erro ao gerar pagamento PIX: resposta inválida.\n" . print_r($resultado, true));
    echo "<h3 style='color:red; text-align:center;'>Erro ao gerar pagamento PIX. Tente novamente.</h3>";
    exit;
}

// ===== DADOS DO PIX =====
$codigoPagamento = $resultado->id;
$status = $resultado->status;
$qr_base64 = $resultado->point_of_interaction->transaction_data->qr_code_base64;
$qr_code = $resultado->point_of_interaction->transaction_data->qr_code;

// ===== SALVA STATUS NO BANCO =====
$stmt2 = $conn->prepare("INSERT INTO status (status, codigo, ncadastro, nome_cadastro, cpf_cadastro, email_principal, tel_celular, data_cadastro) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
$stmt2->bind_param("ssssssss", $status, $codigoPagamento, $ncadastro, $nome_cadastro, $cpf_cadastro, $email_principal, $tel_celular, $data_cadastro);
$stmt2->execute();
$stmt2->close();
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>

<!-- Required meta tags -->

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<!-- Links Of CSS File -->

<link rel="stylesheet" href="../assets/css/sidebar-menu.css">
<link rel="stylesheet" href="../assets/css/simplebar.css">
<link rel="stylesheet" href="../assets/css/apexcharts.css">
<link rel="stylesheet" href="../assets/css/prism.css">
<link rel="stylesheet" href="../assets/css/rangeslider.css">
<link rel="stylesheet" href="../assets/css/quill.snow.css">
<link rel="stylesheet" href="../assets/css/google-icon.css">
<link rel="stylesheet" href="../https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css">
<link rel="stylesheet" href="../assets/css/swiper-bundle.min.css">
<link rel="stylesheet" href="../assets/css/fullcalendar.main.css">
<link rel="stylesheet" href="../assets/css/jsvectormap.min.css">
<link rel="stylesheet" href="../assets/css/lightpick.css">
<link rel="stylesheet" href="../assets/css/style.css">

<!-- Favicon -->

<link rel="icon" type="image/png" href="../assets/images/favicon.png">

<!-- Title -->

<title>PAGAMENTO POR PIX - <?php echo "" . $config['nome_do_sistema'] . ""?> - <?php echo "" . $config['instituicao'] . ""?></title>
</head>

<body class="boxed-size">

<!-- Start Preloader Area -->

<div class="preloader" id="preloader">
  <div class="preloader">
    <div class="waviy position-relative"> <span class="d-inline-block">A</span> <span class="d-inline-block">R</span> <span class="d-inline-block">N</span> <span class="d-inline-block">T</span> <span class="d-inline-block">S</span> <span class="d-inline-block">A</span> <span class="d-inline-block">D</span> <span class="d-inline-block">M</span> </div>
  </div>
</div>

<!-- End Preloader Area --> 

<!-- Start Main Content Area -->

<div class="container-fluid min-vh-100 d-flex align-items-center justify-content-center py-5">
  <div class="col-lg-6 col-md-8">
    <div class="card bg-white border-0 rounded-3 shadow-sm p-3">
      <div class="card-body p-4">
        <div class="row g-3 text-center">
          
          <div class="mb-4">
            <a href="../index.php"><img width="115px" height="115px" src="../assets/images/logo_rounded.png" alt="logo"></a>
            <h4 class="mb-2">PAGAMENTO - <?php echo $config['nome_do_sistema']; ?><br>
              <small class="text-muted"><?php echo $config['instituicao']; ?></small>
            </h4>
          </div>

          <svg class="mb-3" width="120px" height="120px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
            <path fill="#6b74da" d="M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256 256-114.6 256-256S397.4 0 256 0zm92.7 157.1c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-128 128c-6.2 6.2-16.4 6.2-22.6 0l-64-64c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l52.7 52.7 116.7-116.7z"/>
          </svg>

          <h4 class="fs-30 fw-semibold mb-2">Pagamento via PIX</h4>
          <p class="fs-17 mb-3">
            <strong>Nome:</strong> <?php echo htmlspecialchars($nome_cadastro); ?><br>
            <strong>CPF/CNPJ:</strong> <?php echo htmlspecialchars($cpf_cadastro); ?><br>
            <strong>Data do cadastro:</strong> <?php echo date("d/m/Y H:i:s", strtotime($data_cadastro)); ?><br>
            <strong>Valor:</strong> R$ 10,00
          </p>

          <!-- QR CODE PIX -->
          <div class="bg-light p-3 rounded mb-3">
            <img src="data:image/png;base64,<?= $qr_base64 ?>" alt="QR Code PIX" width="220px" class="mb-2">
            <p class="small text-muted mb-0">Escaneie o QR Code acima ou copie o código abaixo:</p>
          </div>

          <!-- Código PIX -->
          <textarea readonly class="form-control text-center" id="pixCopiaCola" rows="3"><?= htmlspecialchars($qr_code) ?></textarea>
          <button class="btn btn-primary mt-3" onclick="copiarPix()">Copiar código PIX</button>

          <p class="text-muted small mt-3 mb-0">
            Após o pagamento, a confirmação ocorrerá automaticamente em instantes.<br>
            <strong>Matrícula:</strong> <?= htmlspecialchars($ncadastro) ?>
          </p>

        </div>
      </div>
    </div>
  </div>
</div>

<script>
function copiarPix() {
  var texto = document.getElementById("pixCopiaCola");
  texto.select();
  texto.setSelectionRange(0, 99999);
  navigator.clipboard.writeText(texto.value)
    .then(() => alert("Código PIX copiado com sucesso!"))
    .catch(() => alert("Erro ao copiar o código."));
}
</script>

<!-- Start Main Content Area --> 

<!-- Link Of JS File --> 

<!-- Scripts -->   
<script src="../config/cep-autofill.js"></script> 
<script src="../config/mascaras.js"></script> 
<script src="../config/vrifica_campos_form.js"></script> 
<script src="../config/feedback_campos_form.js"></script> 
<script src="../assets/js/bootstrap.bundle.min.js"></script>

<!-- Scripts para remover --> 
<script src="../assets/js/sidebar-menu.js"></script> 
<script src="../assets/js/dragdrop.js"></script> 
<script src="../assets/js/rangeslider.min.js"></script> 
<script src="../assets/js/quill.min.js"></script> 
<script src="../assets/js/data-table.js"></script> 
<script src="../assets/js/prism.js"></script> 
<script src="../assets/js/clipboard.min.js"></script> 
<script src="../assets/js/feather.min.js"></script> 
<script src="../assets/js/feather.min.js"></script> 
<script src="../assets/js/simplebar.min.js"></script> 
<script src="../assets/js/apexcharts.min.js"></script> 
<script src="../assets/js/echarts.min.js"></script> 
<script src="../assets/js/swiper-bundle.min.js"></script> 
<script src="../assets/js/fullcalendar.main.js"></script> 
<script src="../assets/js/jsvectormap.min.js"></script> 
<script src="../assets/js/world-merc.js"></script> 
<script src="../assets/js/moment.min.js"></script> 
<script src="../assets/js/lightpick.js"></script> 
<script src="../assets/js/custom/apexcharts.js"></script> 
<script src="../assets/js/custom/echarts.js"></script> 
<script src="../assets/js/custom/custom.js"></script>
</body>
</html>