<?php
require "../config/db.php";
$config = require '../config/config.php';
@ini_set('display_errors', '1');
error_reporting(E_ALL);
session_start();
date_default_timezone_set('America/Sao_Paulo');
    $ncadastro = $_GET['ncadastro'];

// ===== Handler AJAX para verificar status PIX =====
if (isset($_GET['ajax']) && isset($_GET['ncadastro'])) {
    $ncadastro = $conn->real_escape_string($_GET['ncadastro']);
    $sql = "SELECT status FROM status WHERE ncadastro = '$ncadastro' ORDER BY id DESC LIMIT 1";
    $res = $conn->query($sql);
    if ($res && $res->num_rows > 0) {
        $row = $res->fetch_assoc();
        echo json_encode(['status' => trim($row['status'])]);
    } else {
        echo json_encode(['status' => 'nao_encontrado']);
    }
    exit;
}
/*if (empty($_POST["codigoproponente"])) {
    header("Location: https://exercitodasnacoes.org/sistema/");
    exit;
}*/
$result_usuario = "SELECT * FROM cadastro WHERE ncadastro = '$ncadastro'";
$resultado_usuario = mysqli_query($conn, $result_usuario);
$dados = mysqli_fetch_assoc($resultado_usuario);
$id = $dados["id"];
$ncadastro  =  $dados["ncadastro"];
$nome_completo  =  $dados["nome_completo"];
$cpf_cnpj  =  $dados["cpf_cnpj"];
$telefone_celular  =  $dados["telefone_celular"];
$email_principal  =  $dados["email_principal"];
$cep  =  $dados["cep"];
$logradouro  =  $dados["logradouro"];
$numero  =  $dados["numero"];
$complemento  =  $dados["complemento"];
$bairro  =  $dados["bairro"];
$cidade  =  $dados["cidade"];
$estado  =  $dados["estado"];
$_SESSION['id'] = $id;
// ===== Deletar registro no pagamento =====
$delete = $conn->prepare("DELETE FROM status WHERE ncadastro = ?");
$delete->bind_param("s", $ncadastro);
$delete->execute();
$delete->close();
// ===== Criar cobrança via PIX (MercadoPago) =====
$caracteres = '123456789ABCDEFGHIJKLMNPQRSTUVWXYZ';
$codigoKey = substr(str_shuffle($caracteres), 0, 5) . '-' . substr(str_shuffle($caracteres), 0, 8) . '-' . substr(str_shuffle($caracteres), 0, 4);
$dados = [
    "transaction_amount" => 00.10,
    "description" => "CARTEIRA CERTIFICADA COM QR CODE",
    "external_reference" => "2",
    "payment_method_id" => "pix",
    "notification_url" => "https://carteiracomqrcode.com.br/alfa&omega/pix/notification.php",
    "payer" => [
        "email" => $email_principal,
        "first_name" => $nome_completo,
        "last_name" => "CREDENCIADO",
        "identification" => [
            "type" => "CPF",
            "number" => $cpf_cnpj
        ],
        "address" => [
            "zip_code" => $cep,
            "street_name" => $logradouro,
            "street_number" => $numero,
            "neighborhood" => $bairro,
            "city" => $cidade,
            "federal_unit" => $estado
        ]
    ]
];
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'https://api.mercadopago.com/v1/payments',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => json_encode($dados),
    CURLOPT_HTTPHEADER => [
        'accept: application/json',
        'content-type: application/json',
        'X-Idempotency-Key: ' . $codigoKey,
        'Authorization: Bearer APP_USR-2436048829893619-100910-55c3c8158a25c7da48cc958cf677ae56-35703420'
    ],
]);
$response = curl_exec($curl);
$resultado = json_decode($response);
curl_close($curl);
if (
    !isset($resultado->id) ||
    !isset($resultado->status) ||
    !isset($resultado->point_of_interaction->transaction_data->qr_code)
) {
    error_log("Erro ao gerar pagamento PIX: resposta inválida.\n" . print_r($resultado, true));
    echo "<script>
        alert('Erro ao gerar pagamento. Por favor, tente novamente em instantes.');
        window.location.href = 'https://carteiracomqrcode.com.br/alfa&omega/';
    </script>";
    exit;
}
// ===== Dados extraídos com segurança =====
$codigoPagamento = $resultado->id;
$status = $resultado->status;
$qr_base64 = $resultado->point_of_interaction->transaction_data->qr_code_base64 ?? null;
$qr_code = $resultado->point_of_interaction->transaction_data->qr_code;
// ===== Inserir status no banco =====
$stmt = $conn->prepare("INSERT INTO status (status, codigo, ncadastro, telefone_celular, email_principal,
    nome_completo, cpf_cnpj
  ) VALUES (?, ?, ?, ?, ?, ?, ?)
");
if ($stmt === false) {
    error_log("Erro ao preparar statement: " . $conn->error);
    die("Erro interno ao preparar consulta.");
}
$stmt->bind_param(
    "sssssss", $status, $codigoPagamento, $ncadastro, $telefone_celular, $email_principal, $nome_completo, $cpf_cnpj
);
if (!$stmt->execute()) {
    error_log("Erro ao executar statement: " . $stmt->error);
    echo "<script>
        alert('Erro ao salvar status de pagamento.');
        window.location.href = 'https://teste.arantestecnologia.com.br/carteira/';
    </script>";
    exit;
}
$stmt->close();
$_SESSION["ncadastro"] = $ncadastro;
$_SESSION["nome_completo"] = $nome_completo;
?>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <!-- CSS Base -->
  <link rel="stylesheet" href="../assets/css/sidebar-menu.css">
  <link rel="stylesheet" href="../assets/css/simplebar.css">
  <link rel="stylesheet" href="../assets/css/apexcharts.css">
  <link rel="stylesheet" href="../assets/css/prism.css">
  <link rel="stylesheet" href="../assets/css/rangeslider.css">
  <link rel="stylesheet" href="../assets/css/quill.snow.css">
  <link rel="stylesheet" href="../assets/css/google-icon.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css">
  <link rel="stylesheet" href="../assets/css/swiper-bundle.min.css">
  <link rel="stylesheet" href="../assets/css/fullcalendar.main.css">
  <link rel="stylesheet" href="../assets/css/jsvectormap.min.css">
  <link rel="stylesheet" href="../assets/css/lightpick.css">
  <link rel="stylesheet" href="../assets/css/style.css">

  <link rel="icon" type="image/png" href="../assets/images/favicon.png">

  <title>PAGAMENTO POR PIX - <?= $config['nome_do_sistema'] ?> - <?= $config['instituicao'] ?></title>

  <style>
    .pix-container {
      animation: fadeIn 1s ease;
    }
    .status-msg {
      margin-top: 15px;
      font-weight: 600;
      color: #2b7a78;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }
  </style>
</head>

<body class="boxed-size">

<!-- Preloader -->
<div class="preloader" id="preloader">
  <div class="waviy position-relative">
    <span class="d-inline-block">A</span>
    <span class="d-inline-block">R</span>
    <span class="d-inline-block">N</span>
    <span class="d-inline-block">T</span>
    <span class="d-inline-block">S</span>
    <span class="d-inline-block">A</span>
    <span class="d-inline-block">D</span>
    <span class="d-inline-block">M</span>
  </div>
</div>

<!-- Conteúdo Principal -->
<div class="container-fluid min-vh-100 d-flex align-items-center justify-content-center py-5">
  <div class="col-lg-6 col-md-8">
    <div class="card bg-white border-0 rounded-3 shadow-sm p-3 pix-container">
      <div class="card-body p-4 text-center">
        <a href="../index.php">
          <img width="115px" height="115px" src="../assets/images/logo_rounded.png" alt="logo">
        </a>
        <h4 class="mt-3 mb-2">
          PAGAMENTO VIA PIX - <?= $config['nome_do_sistema']; ?><br>
          <small class="text-muted"><?= $config['instituicao']; ?></small>
        </h4>

        <div class="mt-3 mb-3">
          <p class="fs-17 mb-2">
            <strong>Nome:</strong> <?= htmlspecialchars($nome_completo); ?><br>
            <strong>CPF/CNPJ:</strong> <?= htmlspecialchars($cpf_cnpj); ?><br>
            <strong>Valor:</strong> R$ 10,00
          </p>
        </div>

        <?php if ($qr_base64): ?>
        <div class="bg-light p-3 rounded mb-3">
          <img class="qr" src="data:image/jpeg;base64, <?= $qr_base64 ?>" alt="QR Code PIX">
          <p class="small text-muted mb-0">Escaneie o QR Code acima ou copie o código abaixo:</p>
        </div>

        <textarea readonly class="form-control text-center" id="pixcode" rows="3"><?= htmlspecialchars($qr_code) ?></textarea>
        <button class="btn btn-primary mt-3" onclick="copiarCodigo()">Copiar código PIX</button>

        <p class="text-muted small mt-3 mb-0">
          Após o pagamento, a confirmação ocorrerá automaticamente em instantes.<br>
          <strong>Nº Cadastro:</strong> <?= htmlspecialchars($ncadastro) ?>
        </p>

        <div id="statusPagamento" class="status-msg mt-3">🔄 Aguardando pagamento...</div>

        <?php else: ?>
          <div class="alert alert-danger mt-3">❌ Erro ao gerar o QR Code. Por favor, tente novamente mais tarde.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<script>
  const ncadastro = "<?= addslashes($ncadastro) ?>";
  async function verificarStatus() {
    try {
      const response = await fetch(`<?= basename(__FILE__) ?>?ajax=1&ncadastro=${encodeURIComponent(ncadastro)}`, {
        cache: 'no-cache'
      });
      const data = await response.json();
      console.log("Status recebido:", data.status);
      const status = (data.status || "").trim().toLowerCase();
      if (status === "approved" || status === "aprovado") {
        window.location.href = `https://carteiracomqrcode.com.br/alfa&omega/pagamentoaprovado.php`;
      }
    } catch (err) {
      console.error("Erro ao verificar status:", err);
    }
  }
  function copiarCodigo() {
    const texto = document.getElementById("pixCode").innerText;
    navigator.clipboard.writeText(texto)
      .then(() => alert("Código PIX copiado com sucesso!"))
      .catch(() => alert("Erro ao copiar o código."));
  }
  setInterval(verificarStatus, 5000);
  verificarStatus();
</script>

<!-- Scripts -->
<script src="../config/cep-autofill.js"></script> 
<script src="../config/mascaras.js"></script> 
<script src="../config/vrifica_campos_form.js"></script> 
<script src="../config/feedback_campos_form.js"></script> 
<script src="../assets/js/bootstrap.bundle.min.js"></script>
<script src="../assets/js/sidebar-menu.js"></script> 
<script src="../assets/js/simplebar.min.js"></script> 
<script src="../assets/js/custom/custom.js"></script>

</body>
</html>
