<?php
$config = require 'config/config.php';

@ini_set( 'display_errors', '1' );
error_reporting( E_ALL );
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>

<!-- Required meta tags -->

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<!-- Links Of CSS File -->

<link rel="stylesheet" href="assets/css/sidebar-menu.css">
<link rel="stylesheet" href="assets/css/simplebar.css">
<link rel="stylesheet" href="assets/css/apexcharts.css">
<link rel="stylesheet" href="assets/css/prism.css">
<link rel="stylesheet" href="assets/css/rangeslider.css">
<link rel="stylesheet" href="assets/css/quill.snow.css">
<link rel="stylesheet" href="assets/css/google-icon.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css">
<link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
<link rel="stylesheet" href="assets/css/fullcalendar.main.css">
<link rel="stylesheet" href="assets/css/jsvectormap.min.css">
<link rel="stylesheet" href="assets/css/lightpick.css">
<link rel="stylesheet" href="assets/css/style2.css">

<!-- Favicon -->

<link rel="icon" type="image/png" href="assets/images/favicon.png">

<!-- Title -->

<title>CRIAR USUÁRIO - <?php echo "" . $config['nome_do_sistema'] . ""?> - <?php echo "" . $config['instituicao'] . ""?></title>
</head>

<body class="boxed-size">

<!-- Start Preloader Area -->

<div class="preloader" id="preloader">
  <div class="preloader">
    <div class="waviy position-relative"> <span class="d-inline-block">A</span> <span class="d-inline-block">R</span> <span class="d-inline-block">N</span> <span class="d-inline-block">T</span> <span class="d-inline-block">S</span> <span class="d-inline-block">A</span> <span class="d-inline-block">D</span> <span class="d-inline-block">M</span> </div>
  </div>
</div>

<!-- End Preloader Area --> 

<!-- Start Main Content Area -->
<div class="container-fluid min-vh-100 d-flex align-items-center justify-content-center py-5">
  <div class="col-lg-8 col-md-10">
    <div class="card bg-white border-0 rounded-3 shadow-sm p-3">
      <div class="card-body p-4">
        <div class="row align-items-center"> 
          
          <!-- Título -->
          <div class="col-xl-12 text-center mb-4">
            <h4> Criar Usuário - <?php echo $config['nome_do_sistema']; ?> <br>
              <small class="text-muted"><?php echo $config['instituicao']; ?></small> </h4>
          </div>
          
          <!-- Imagem à esquerda -->
          <div class="col-lg-6 d-none d-lg-block"> <img src="assets/images/register.jpg" class="rounded-3 w-100" alt="Criar Usuário"> </div>
          
          <!-- Formulário -->
          <div class="col-lg-6">
            <div class="mw-480 ms-lg-auto"> 
              
              <!-- Boas-vindas -->
              <div class="col-xl-12 mb-4">
                <h5 class="fw-semibold">Bem-vindo(a)!</h5>
                <p class="text-secondary mb-0"> Preencha os campos abaixo para criar sua conta. </p>
              </div>
              <form action="exe_novo_usuario.php" method="POST"  class="needs-validation">
                <div class="row"> 
                  
                  <!-- Nome -->
                  <div class="col-md-12 mb-4">
                    <label for="nome" class="form-label text-secondary">Nome Completo</label>
                    <div class="position-relative">
                      <input type="text" class="form-control h-55 ps-5" id="nome" name="nome" placeholder="Digite seu nome completo" required>
                      <div class="valid-feedback">Tudo certo!</div>
                      <div class="invalid-feedback">Por favor, informe seu nome.</div>
                      <i class="ri-user-3-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20" style="top: 13px !important;"></i> </div>
                  </div>
                  
                  <!-- CPF ou CNPJ -->
                  <div class="col-md-6 mb-4">
                    <label for="cpf_cnpj" class="form-label text-secondary">CPF ou CNPJ</label>
                    <div class="position-relative">
                      <input type="text" class="form-control h-55 ps-5" id="cpf_cnpj" name="cpf_cnpj"
                        oninput="mascaraCpfCnpj(this)" onblur="verificaCpfCnpj(this)" maxlength="18"
                        placeholder="Digite CPF ou CNPJ" required>
                      <div class="valid-feedback">Tudo certo!</div>
                      <div class="invalid-feedback">CPF ou CNPJ inválido.</div>
                      <i class="ri-id-card-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20"
                        style="top: 13px !important;"></i> </div>
                  </div>
                  
                  <!-- Email principal -->
                  <div class="col-md-6 mb-4">
                    <label for="email_principal" class="form-label text-secondary">E-mail Principal</label>
                    <div class="position-relative">
                      <input type="email" class="form-control h-55 ps-5" id="email_principal" name="email_principal"
                        placeholder="email@exemplo.com" required onblur="verificaEmail(this)">
                      <div class="valid-feedback">Tudo certo!</div>
                      <div class="invalid-feedback">Por favor, insira um email válido.</div>
                      <i class="ri-mail-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20"
                        style="top: 13px !important;"></i> </div>
                  </div>
                  
                  <!-- Instituição -->
                  <div class="col-md-6 mb-4">
                    <label for="instituicao" class="form-label text-secondary">Instituição</label>
                    <div class="position-relative">
                      <input type="text" class="form-control h-55 ps-5" id="instituicao" name="instituicao" placeholder="Digite a instituição" required>
                      <div class="valid-feedback">Tudo certo!</div>
                      <div class="invalid-feedback">Por favor, informe a instituição.</div>
                      <i class="ri-building-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20"
                        style="top: 13px !important;"></i> </div>
                  </div>
                  
                  <!-- Cargo/Função -->
                  <div class="col-md-6 mb-4">
                    <label for="cargo" class="form-label text-secondary">Cargo / Função</label>
                    <div class="position-relative">
                      <input type="text" class="form-control h-55 ps-5" id="cargo" name="cargo" placeholder="Digite o cargo ou função" required>
                      <div class="valid-feedback">Tudo certo!</div>
                      <div class="invalid-feedback">Por favor, informe o cargo ou função.</div>
                      <i class="ri-briefcase-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20"
                        style="top: 13px !important;"></i> </div>
                  </div>
                  
                  <!-- Senha -->
                  <div class="col-md-6 mb-4">
                    <label for="senha" class="form-label text-secondary">Senha</label>
                    <div class="position-relative">
                      <input type="password" class="form-control h-55 ps-5" id="senha" name="senha" 
           placeholder="Digite sua senha" minlength="6" required>
                      <div class="valid-feedback">Tudo certo!</div>
                      <div class="invalid-feedback">A senha deve ter no mínimo 6 caracteres.</div>
                      <i class="ri-lock-password-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20"
       style="top: 13px !important;"></i> </div>
                  </div>
                  
                  <!-- Confirmar Senha -->
                  <div class="col-md-6 mb-4">
                    <label for="confirma_senha" class="form-label text-secondary">Confirmar Senha</label>
                    <div class="position-relative">
                      <input type="password" class="form-control h-55 ps-5" id="confirma_senha" name="confirma_senha" 
           placeholder="Confirme sua senha" minlength="6" required>
                      <div class="valid-feedback">Tudo certo!</div>
                      <div class="invalid-feedback">As senhas não conferem.</div>
                      <i class="ri-lock-password-line position-absolute top-0 start-0 fs-20 text-gray-light ps-20"
       style="top: 13px !important;"></i> </div>
                  </div>
<script>
  const senha = document.getElementById("senha");
  const confirmaSenha = document.getElementById("confirma_senha");

  confirmaSenha.addEventListener("input", function () {
    if (confirmaSenha.value !== senha.value) {
      confirmaSenha.setCustomValidity("As senhas não conferem.");
    } else {
      confirmaSenha.setCustomValidity("");
    }
  });
</script> 
                </div>
                
                <!-- Botão Criar -->
                <div class="form-group mb-4">
                  <button type="submit" class="btn btn-success fw-medium py-2 px-3 w-100">
                  <div class="d-flex align-items-center justify-content-center py-1"> <i class="material-symbols-outlined text-white fs-20 me-2">person_add</i> <span>Criar Conta</span> </div>
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Start Main Content Area --> 

<!-- Link Of JS File --> 

<!-- Scripts --> 
<script src="config/cep-autofill.js"></script> 
<script src="config/mascaras.js"></script> 
<script src="config/vrifica_campos_form.js"></script> 
<script src="config/feedback_campos_form.js"></script> 
<script src="assets/js/bootstrap.bundle.min.js"></script> 

<!-- Scripts para remover --> 
<script src="assets/js/sidebar-menu.js"></script> 
<script src="assets/js/dragdrop.js"></script> 
<script src="assets/js/rangeslider.min.js"></script> 
<script src="assets/js/quill.min.js"></script> 
<script src="assets/js/data-table.js"></script> 
<script src="assets/js/prism.js"></script> 
<script src="assets/js/clipboard.min.js"></script> 
<script src="assets/js/feather.min.js"></script> 
<script src="assets/js/feather.min.js"></script> 
<script src="assets/js/simplebar.min.js"></script> 
<script src="assets/js/apexcharts.min.js"></script> 
<script src="assets/js/echarts.min.js"></script> 
<script src="assets/js/swiper-bundle.min.js"></script> 
<script src="assets/js/fullcalendar.main.js"></script> 
<script src="assets/js/jsvectormap.min.js"></script> 
<script src="assets/js/world-merc.js"></script> 
<script src="assets/js/moment.min.js"></script> 
<script src="assets/js/lightpick.js"></script> 
<script src="assets/js/custom/apexcharts.js"></script> 
<script src="assets/js/custom/echarts.js"></script> 
<script src="assets/js/custom/custom.js"></script>
</body>
</html>