<?php
$config = require 'config/config.php';
@ini_set( 'display_errors', '1' );
error_reporting( E_ALL );
session_start();
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>

<!-- Required meta tags -->

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<!-- Links Of CSS File -->

<link rel="stylesheet" href="assets/css/sidebar-menu.css">
<link rel="stylesheet" href="assets/css/simplebar.css">
<link rel="stylesheet" href="assets/css/apexcharts.css">
<link rel="stylesheet" href="assets/css/prism.css">
<link rel="stylesheet" href="assets/css/rangeslider.css">
<link rel="stylesheet" href="assets/css/quill.snow.css">
<link rel="stylesheet" href="assets/css/google-icon.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon@4.5.0/fonts/remixicon.css">
<link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
<link rel="stylesheet" href="assets/css/fullcalendar.main.css">
<link rel="stylesheet" href="assets/css/jsvectormap.min.css">
<link rel="stylesheet" href="assets/css/lightpick.css">
<link rel="stylesheet" href="assets/css/style2.css">

<!-- Favicon -->

<link rel="icon" type="image/png" href="assets/images/favicon.png">

<!-- Title -->

<title>INÍCIO - <?php echo "" . $config['nome_do_sistema'] . ""?> - <?php echo "" . $config['instituicao'] . ""?></title>
</head>

<body class="boxed-size">

<!-- Start Preloader Area -->

<div class="preloader" id="preloader">
  <div class="preloader">
    <div class="waviy position-relative"> <span class="d-inline-block">A</span> <span class="d-inline-block">R</span> <span class="d-inline-block">N</span> <span class="d-inline-block">T</span> <span class="d-inline-block">S</span> <span class="d-inline-block">A</span> <span class="d-inline-block">D</span> <span class="d-inline-block">M</span> </div>
  </div>
</div>

<!-- End Preloader Area --> 

<!-- Start Main Content Area -->
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Acesso ao Sistema</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css">
  <style>
    body {
      background-color: #f8f9fa;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 30px 10px;
    }

    .card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 4px 16px rgba(0, 0, 0, 0.08);
      overflow: hidden;
      opacity: 0;
      transform: translateY(30px);
      animation: fadeInUp 0.8s ease forwards;
    }

    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .illustration {
      width: 100%;
      border-radius: 10px;
    }

    .btn-option {
      font-size: 1rem;
      border-radius: 8px;
      transition: all 0.3s ease;
    }

    .btn-option:hover {
      transform: scale(1.05);
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .text-muted {
      font-size: 0.9rem;
    }
  </style>
</head>
<body>

<div class="container-fluid">
    <div class="row justify-content-center">
      <div class="col-lg-8 col-md-10">
        <div class="card bg-white p-4">
          <div class="row align-items-center">

            <!-- Imagem -->
            <div class="col-lg-6 d-none d-lg-block">
              <img src="assets/images/login.jpg" class="illustration" alt="Acesso ao Sistema">
            </div>

            <!-- Opções -->
            <div class="col-lg-6 text-center p-4">
              <h4 class="mb-3" align="center"> Login no Sistema - <?php echo $config['nome_do_sistema']; ?> <br>
              <small class="text-muted"><?php echo $config['instituicao']; ?></small> </h4>
              <p class="text-secondary mb-4">Escolha como deseja continuar:</p>

              <div class="d-grid gap-3">
                <a href="login.php" class="btn btn-primary btn-option py-2">
                  <i class="ri-login-box-line me-2"></i> Fazer Login
                </a>
                <a href="cadastro.php" class="btn btn-outline-secondary btn-option py-2">
                  <i class="ri-user-add-line me-2"></i> Fazer Cadastro
                </a>
              </div>

              <hr class="my-4">
              <p class="text-muted mb-0">© <?php echo date('Y'); ?> <a href="https://arantestecnologia.com.br/">Arantes Tecnologia</a> - <a href="https://carteiracomqrcode.com.br/">Carteira com QR Code</a>,<br> Todos os direitos reservados.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>


</body>
</html>


<!-- Start Main Content Area --> 

<!-- Link Of JS File --> 

<!-- Scripts --> 
<script src="config/cep-autofill.js"></script> 
<script src="config/mascaras.js"></script> 
<script src="config/vrifica_campos_form.js"></script> 
<script src="config/feedback_campos_form.js"></script> 
<script src="assets/js/bootstrap.bundle.min.js"></script> 

<!-- Scripts para remover --> 
<script src="assets/js/sidebar-menu.js"></script> 
<script src="assets/js/dragdrop.js"></script> 
<script src="assets/js/rangeslider.min.js"></script> 
<script src="assets/js/quill.min.js"></script> 
<script src="assets/js/data-table.js"></script> 
<script src="assets/js/prism.js"></script> 
<script src="assets/js/clipboard.min.js"></script> 
<script src="assets/js/feather.min.js"></script> 
<script src="assets/js/feather.min.js"></script> 
<script src="assets/js/simplebar.min.js"></script> 
<script src="assets/js/apexcharts.min.js"></script> 
<script src="assets/js/echarts.min.js"></script> 
<script src="assets/js/swiper-bundle.min.js"></script> 
<script src="assets/js/fullcalendar.main.js"></script> 
<script src="assets/js/jsvectormap.min.js"></script> 
<script src="assets/js/world-merc.js"></script> 
<script src="assets/js/moment.min.js"></script> 
<script src="assets/js/lightpick.js"></script> 
<script src="assets/js/custom/apexcharts.js"></script> 
<script src="assets/js/custom/echarts.js"></script> 
<script src="assets/js/custom/custom.js"></script>
</body>
</html>