<?php
require "config/db.php";

// ? Definir timezone para Brasília
date_default_timezone_set('America/Sao_Paulo');

// Ativar exceptions do MySQLi
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        // Dados do formulário
        $nome_completo      = $_POST['nome'] ?? null;
        $cpf_cnpj           = $_POST['cpf_cnpj'] ?? null;
        $email_principal    = $_POST['email_principal'] ?? null;
        $instituicao        = $_POST['instituicao'] ?? null;
        $cargo              = $_POST['cargo'] ?? null;
        $senha              = $_POST['senha'] ?? null;
        $confirma_senha     = $_POST['confirma_senha'] ?? null;

        // ⚠️ Validação de senha
        if ($senha !== $confirma_senha) {
            echo "<script>alert('❌ As senhas não conferem!'); history.back();</script>";
            exit;
        }

        if (strlen($senha) < 6) {
            echo "<script>alert('❌ A senha deve ter pelo menos 6 caracteres!'); history.back();</script>";
            exit;
        }

        // 🔎 Verificar se CPF/CNPJ já existe
        $checkCpf = $conn->prepare("SELECT id FROM usuarios WHERE cpf_cnpj = ?");
        $checkCpf->bind_param("s", $cpf_cnpj);
        $checkCpf->execute();
        $checkCpf->store_result();

        if ($checkCpf->num_rows > 0) {
            echo "<script>alert('❌ Este CPF/CNPJ já está cadastrado!'); history.back();</script>";
            exit;
        }
        $checkCpf->close();

        // 🔎 Verificar se Email já existe
        $checkEmail = $conn->prepare("SELECT id FROM usuarios WHERE email_principal = ?");
        $checkEmail->bind_param("s", $email_principal);
        $checkEmail->execute();
        $checkEmail->store_result();

        if ($checkEmail->num_rows > 0) {
            echo "<script>alert('❌ Este e-mail já está cadastrado!'); history.back();</script>";
            exit;
        }
        $checkEmail->close();

        // 📅 Data e número de cadastro
        $data_cadastro = date('Y-m-d H:i:s');
        $ncadastro = date('YmdHis'); // exemplo: 20250911185530

        // Hash seguro da senha
        $senha_hash = password_hash($senha, PASSWORD_DEFAULT);

        // SQL de inserção
        $sql = "INSERT INTO usuarios 
            (nome_completo, cpf_cnpj, email_principal, instituicao, cargo, senha, ncadastro, data_cadastro)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssssss",
            $nome_completo, $cpf_cnpj, $email_principal, $instituicao, $cargo, $senha_hash, $ncadastro, $data_cadastro
        );

        if ($stmt->execute()) {
            // ✅ Sucesso → redireciona passando o número de cadastro
            header("Location: verificar_usuario.php?ncadastro=" . urlencode($ncadastro));
            exit;
        }

    } catch (Exception $e) {
        echo "<script>alert('⚠️ Erro inesperado: " . addslashes($e->getMessage()) . "'); history.back();</script>";
    }
}
?>
