(function() {
  function maskDate(raw) {
    let v = String(raw || '').replace(/\D/g, '');
    if (!v) return '';
    if (v.length <= 2) return v;
    if (v.length <= 4) return v.replace(/(\d{2})(\d+)/, '$1/$2');
    return v.replace(/(\d{2})(\d{2})(\d+)/, '$1/$2/$3').substr(0, 10);
  }

  function isValidDate(str) {
    // precisa ter 10 caracteres e estar no formato DD/MM/AAAA
    if (!/^\d{2}\/\d{2}\/\d{4}$/.test(str)) return false;

    const [dia, mes, ano] = str.split('/').map(Number);
    const data = new Date(ano, mes - 1, dia);
    return (
      data.getFullYear() === ano &&
      data.getMonth() === mes - 1 &&
      data.getDate() === dia
    );
  }

  function onInput(e) {
    const el = e.target;
    el.value = maskDate(el.value);
  }

  function onBlur(e) {
    const el = e.target;
    const valido = isValidDate(el.value);
    if (!valido) {
      el.classList.add('is-invalid');
      el.classList.remove('is-valid');
    } else {
      el.classList.remove('is-invalid');
      el.classList.add('is-valid');
    }
  }

  function attachMaskTo(id) {
    const el = document.getElementById(id);
    if (!el) return;
    el.addEventListener('input', onInput);
    el.addEventListener('blur', onBlur);
    el.addEventListener('paste', function() {
      setTimeout(() => { el.value = maskDate(el.value); }, 0);
    });
  }

  function init() {
    attachMaskTo('data_nascimento');
  }

  if (document.readyState === 'loading')
    document.addEventListener('DOMContentLoaded', init);
  else
    init();
})();


// Função de máscara para CEP
function mascaraCEP(input) {
    input.value = input.value.replace(/\D/g, '').replace(/^(\d{5})(\d)/, '$1-$2').slice(0, 9);
}

function mascaraCpfCnpj(input) {
    let value = input.value.replace(/\D/g, '');

    if (value.length <= 11) {
        value = value.slice(0, 11);
        // CPF: 000.000.000-00
        value = value.replace(/(\d{3})(\d)/, '$1.$2');
        value = value.replace(/(\d{3})(\d)/, '$1.$2');
        value = value.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
    } else {
        value = value.slice(0, 14);
        // CNPJ: 00.000.000/0000-00
        value = value.replace(/^(\d{2})(\d)/, '$1.$2');
        value = value.replace(/^(\d{2})\.(\d{3})(\d)/, '$1.$2.$3');
        value = value.replace(/\.(\d{3})(\d)/, '.$1/$2');
        value = value.replace(/(\d{4})(\d)/, '$1-$2');
    }

    input.value = value;
}

// Função de máscara para telefone fixo (com ou sem DDD)
function mascaraTelefoneFixo(input) {
    input.value = input.value
        .replace(/\D/g, '')
        .replace(/^(\d{2})(\d)/, '($1) $2')
        .replace(/(\d{4})(\d)/, '$1-$2')
        .slice(0, 14);
}

// Função de máscara para celular (com ou sem DDD)
function mascaraCelular(input) {
    input.value = input.value
        .replace(/\D/g, '')
        .replace(/^(\d{2})(\d)/, '($1) $2')
        .replace(/(\d{5})(\d)/, '$1-$2')
        .slice(0, 15);
}

// Função de máscara para telefone celular e fixos
function mascaraTelefone(input) {
  // mantém só números e limita a 11 (2 DDD + 9 máximo)
  let digits = (input.value || '').replace(/\D/g, '').slice(0, 11);
  let formatted = '';

  if (digits.length === 0) {
    formatted = '';
  } else if (digits.length <= 2) {
    formatted = '(' + digits;
  } else if (digits.length <= 6) {
    // (DD) ####
    formatted = '(' + digits.slice(0,2) + ') ' + digits.slice(2);
  } else if (digits.length <= 10) {
    // (DD) ####-####
    formatted = '(' + digits.slice(0,2) + ') ' + digits.slice(2,6) + '-' + digits.slice(6);
  } else {
    // 11 dígitos -> (DD) 9####-####
    formatted = '(' + digits.slice(0,2) + ') ' + digits.slice(2,7) + '-' + digits.slice(7);
  }

  input.value = formatted;
}

// opcional: garante formatação correta ao colar
document.addEventListener('DOMContentLoaded', function () {
  const el = document.getElementById('telefone') || document.querySelector('[data-mask="telefone"]');
  if (el) {
    el.addEventListener('paste', function () {
      setTimeout(() => mascaraTelefone(el), 0);
    });
  }
});

// Máscara para RG (opcional)
function mascaraRG(input) {
    input.value = input.value
        .replace(/\D/g, '')
        .replace(/(\d{2})(\d)/, '$1.$2')
        .replace(/(\d{3})(\d)/, '$1.$2')
        .replace(/(\d{3})(\d{1})$/, '$1-$2')
        .slice(0, 12);
}

// máscara usuario login
(function(){
  const input = document.getElementById('usuario');
  let isComposing = false;

  // detectar composição (IME) para evitar interferir durante entrada balcâ de caracteres
  input.addEventListener('compositionstart', () => isComposing = true);
  input.addEventListener('compositionend', () => {
    isComposing = false;
    // após composição, formatar
    formatAndPreserveCaret(input);
  });

  // formatação ao digitar e ao colar
  input.addEventListener('input', () => {
    if (!isComposing) formatAndPreserveCaret(input);
  });
  input.addEventListener('paste', (e) => {
    // espera o paste aplicar e depois formata
    setTimeout(() => formatAndPreserveCaret(input), 0);
  });

  // detectar letras (fallback sem usar \p{L} -> compatível)
  function containsLetter(str) {
    return /[A-Za-zÀ-ÖØ-öø-ÿ]/.test(str);
  }

  function formatAndPreserveCaret(el) {
    const raw = el.value;
    const selStart = el.selectionStart || raw.length;

    // se tem '@' → é email (não removemos pontos/hífens porque user provavelmente está digitando endereço)
    if (raw.indexOf('@') !== -1) {
      // somente limpar espaços extras no começo/fim
      el.value = raw.trimStart();
      // colocar caret numa posição coerente (mantém onde estava)
      try { el.setSelectionRange(selStart, selStart); } catch(e) {}
      return;
    }

    // se contém letras (mas sem '@') → usuário provavelmente quer digitar algo que não é só número.
    // remover somente os separadores (.,-/ e espaços) que a máscara adicionaria anteriormente
    if (containsLetter(raw)) {
      const cleaned = raw.replace(/[.\-\/\s]/g, '');
      el.value = cleaned;
      // colocar o cursor no fim (evita posições erradas quando mistura letras/números)
      try { el.setSelectionRange(cleaned.length, cleaned.length); } catch(e) {}
      return;
    }

    // caso contrário: tratar como número => aplicar CPF ou CNPJ
    let digits = raw.replace(/\D/g, '');
    if (digits.length === 0) {
      el.value = '';
      return;
    }

    // calcular quantos dígitos havia antes do caret pra preservar a posição
    const digitsBeforeCaret = (raw.slice(0, selStart).match(/\d/g) || []).length;

    let formatted = '';
    if (digits.length <= 11) {
      // CPF 000.000.000-00
      digits = digits.slice(0, 11);
      formatted = digits
        .replace(/(\d{3})(\d)/, "$1.$2")
        .replace(/(\d{3})(\d)/, "$1.$2")
        .replace(/(\d{3})(\d{1,2})$/, "$1-$2");
    } else {
      // CNPJ 00.000.000/0000-00
      digits = digits.slice(0, 14);
      formatted = digits
        .replace(/^(\d{2})(\d)/, "$1.$2")
        .replace(/^(\d{2})\.(\d{3})(\d)/, "$1.$2.$3")
        .replace(/\.(\d{3})(\d)/, ".$1/$2")
        .replace(/(\d{4})(\d)/, "$1-$2");
    }

    el.value = formatted;

    // mapear posição do caret: localizar a posição após o dígito N (digitsBeforeCaret)
    let pos = formatted.length;
    if (digitsBeforeCaret === 0) {
      pos = 0;
    } else {
      let count = 0;
      pos = formatted.length;
      for (let i = 0; i < formatted.length; i++) {
        if (/\d/.test(formatted[i])) count++;
        if (count === digitsBeforeCaret) {
          pos = i + 1;
          break;
        }
      }
    }

    try { el.setSelectionRange(pos, pos); } catch(e) {}
  }
})();
