// Script para ativar os feedbacks de validação do Bootstrap em tempo real (apenas no blur)
(function () {
  'use strict'

  var forms = document.querySelectorAll('.needs-validation')

  Array.prototype.slice.call(forms)
    .forEach(function (form) {
      // Validação no envio
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault()
          event.stopPropagation()
        }
        form.classList.add('was-validated')
      }, false)

      // Validação somente no blur (quando sai do campo)
      var campos = form.querySelectorAll('input, select, textarea')
      campos.forEach(function (campo) {
        campo.addEventListener('blur', function () {
          // Se não for required e estiver vazio → não aplica feedback
          if (!campo.required && campo.value.trim() === "") {
            campo.classList.remove('is-valid', 'is-invalid')
            return
          }

          if (campo.checkValidity()) {
            campo.classList.add('is-valid')
            campo.classList.remove('is-invalid')
          } else {
            campo.classList.add('is-invalid')
            campo.classList.remove('is-valid')
          }
        })
      })
    })
})()
